/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

#define MAXITER     255
#define THRESHOLD   42.
#define STRENGTH	0.1
#define ANIM_SPEED	2.1
#define RE_SPEED	0.1
#define IM_SPEED	0.1


const vec2 fracCenter = vec2(-1.0017, 0.312);
const float time = 50.;


void main(void)
{       
    //float s = 0.01;
    float s = log(exp(1.0 / (10. + pow(time, ANIM_SPEED))));
	vec2 b = vec2(fracCenter.x - 0.5 * s * iResolution.x,
                  fracCenter.y - 0.5 * s * iResolution.y);

    vec2 z = vec2( STRENGTH - 2. * STRENGTH * sin(iGlobalTime * RE_SPEED),
                  -STRENGTH + 2. * STRENGTH * cos(iGlobalTime * IM_SPEED));
    vec2 c = s * gl_FragCoord.xy + b;
    vec4 col = vec4(0., 0., 0., 1.);
    
    int i;
    for (int i = 0; i < MAXITER; ++i) {
        z = vec2(z.x * z.x - z.y * z.y, 2. * z.x * z.y) + c;
        
        col.b = 0.5 + 0.2 * sin(iGlobalTime * sin(0.00001 * iGlobalTime));
        col.g = float(i) * 0.03;
        col.r = 0.5 + 0.2 * cos(iGlobalTime * cos(0.00001 * iGlobalTime));
        
        if (dot(z, z) > THRESHOLD) {
            break;
        }
    }
/*    
    vec2 rPos = vec2(gl_FragCoord.x / iResolution.x, gl_FragCoord.y / iResolution.y);
    vec4 tex = texture2D(iChannel0, rPos);
    
    col.r = 0.96 * col.r  + 0.04 * sin(tex.r * iGlobalTime);
    col.g = 0.98 * col.g  + 0.02 * sin(tex.g * iGlobalTime * 0.6);
    col.b = 0.95 * col.b  + 0.05 * sin(tex.b * iGlobalTime * 0.8);
 */  
    
    gl_FragColor = col;
}